package com.izenpe.zain.cliente.cades.multiples;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartSignRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartSignResponse;

public class GeneracionFirmaCades_ES_T_AttachedParalelo {

	private static final String fileName = "HelloWorld.txt";
	
	public static void main(String[] args) {
		try{
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
			SmartSignRequest smartSignReq = new SmartSignRequest(Propiedades.ZAIN_ENDPOINT);
			smartSignReq.setProfile(Constants.Profile.CMSPKCS7);
			smartSignReq.setSignatureType(Constants.SignatureType.CADES);
			smartSignReq.setSignatureFormat(Constants.SignatureFormat.ES_T);
			smartSignReq.setEnvelopingSignature(true);
			smartSignReq.setLanguage("es");
			smartSignReq.setKeySubjectName(Propiedades.ZAIN_SIGNER);
			smartSignReq.setInputBase64Data(Base64.encode(ZainUtil.readBinaryFile("data/input/" + fileName)));
			SmartSignResponse smartSignResp = smartSignReq.send();
			if (Constantes.RMAJOR_SUCCESS.equals((smartSignResp.getResultMajor()))
					&& smartSignResp.getResultMinor() == null) {
				ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
				String signBase64 = smartSignResp.getSignatureBase64();
				SmartSignRequest smartSignReqCosign = new SmartSignRequest(Propiedades.ZAIN_ENDPOINT);
				smartSignReqCosign.setProfile(Constants.Profile.CMSPKCS7);
				smartSignReqCosign.setLanguage("es");
				smartSignReqCosign.setKeySubjectName(Propiedades.ZAIN_SIGNER);
				smartSignReqCosign.setSignatureFormat(Constants.SignatureFormat.BES);
				smartSignReqCosign.setSignatureType(Constants.SignatureType.CADES);
				smartSignReqCosign.setEnvelopingSignature(true);
				//para indicar que sea firma multiple en paralelo
				smartSignReqCosign.setInputBase64Signature(signBase64);

				SmartSignResponse smartSignResponse = smartSignReqCosign.send();

				if (Constantes.RMAJOR_SUCCESS.equals((smartSignResponse.getResultMajor()))
						&& smartSignResponse.getResultMinor() == null) {
					String destFilename = "data/output/" + fileName + "CADES_ES_TAttachedParalelo.p7s";
					signBase64 = smartSignResponse.getSignatureBase64();
					byte[] data = Base64.decode(signBase64);
					ZainUtil.writeBinaryFile(destFilename, data);
					System.out.println("La firma ha sido generada con xito");
				}else{
					System.out.println("Error en la Generacin de Firma:" + smartSignResponse.getResultMessage());
				}
			} else {
				System.out.println("Error en la Generacin de Firma2:" + smartSignResp.getResultMessage());
			}
		}catch (Exception e) {
			e.printStackTrace();
		}

	}

}
